function interpolation_matrix = create_transformation_matrix_fast(tfm,UData ,VData, XData, YData, n1,n2,focus_size)

%lim1=UData(2)-UData(1);
%lim2=VData(2)-VData(1);
lim1=focus_size(2);
lim2=focus_size(1);

reg_a = maketform('box', fliplr([n1 n2]), ...
                  [UData(1) VData(1)], ...
                  [UData(2) VData(2)]);
reg_b = maketform('box', fliplr([focus_size(1) focus_size(2)]), ...
  [XData(1) YData(1)], ...
  [XData(2) YData(2)]);

new_tform = maketform('composite', fliptform(reg_b), tfm, reg_a);

hi = [focus_size(2) focus_size(1)]; 
lo = ones(1,length(hi));

G = ConstructGrid(lo,hi);
M = tforminv(G,new_tform);
coord_x = (M(:,:,1));
coord_y = (M(:,:,2));
floor_x = floor(coord_x(:));
floor_y = floor(coord_y(:));
aux_indices =find((floor_x > 0)& (floor_y > 0) & ((floor_x +1)<=n2) & ((floor_y +1)<=n1));
floor_x=floor_x(aux_indices);
floor_y=floor_y(aux_indices);
aux_x_1 = floor_x+1 - coord_x(aux_indices);
aux_x_2 = 1-aux_x_1;
aux_y_1 = floor_y+1 - coord_y(aux_indices);
aux_y_2 = 1-aux_y_1;

test_fast = 0;
if test_fast==0
    aux_ind_rows1 = ones(lim1,1)*(1:lim2);
    aux_ind_rows2 = aux_ind_rows1(:) + repmat(lim2.*((0:(lim1-1)))',lim2,1);
    interpolation_matrix = sparse(repmat(aux_ind_rows2,4,1),[(floor_x-1).*n1+floor_y;(floor_x-1).*n1+floor_y+1;...
    floor_x.*n1+floor_y; floor_x.*n1+floor_y+1],[ aux_x_1.*aux_y_1; aux_x_1.*aux_y_2;aux_x_2.*aux_y_1;...
    aux_x_2.*aux_y_2],lim1*lim2,n1*n2,4*lim1*lim2);
else
    aux_ind_rows1 = ones(lim1,1)*(1:lim2);
    aux_ind_rows2 = aux_ind_rows1(:) + repmat(lim2.*((0:(lim1-1)))',lim2,1);
    interpolation_matrix = sparse(repmat(aux_ind_rows2,4,1),[(floor_x-1).*n1+floor_y;(floor_x-1).*n1+floor_y+1;...
    floor_x.*n1+floor_y; floor_x.*n1+floor_y+1],[ aux_x_1.*aux_y_1; aux_x_1.*aux_y_2;aux_x_2.*aux_y_1;...
    aux_x_2.*aux_y_2],lim1*lim2,n1*n2,4*lim1*lim2);
    auxind_rows=[(1:(lim1*lim2))';(1:(lim1*lim2))';...
    (1:(lim1*lim2))';(1:(lim1*lim2))'];
    auxind_cols=[(floor_x-1).*n1+floor_y;(floor_x-1).*n1+floor_y+1;...
    floor_x.*n1+floor_y; floor_x.*n1+floor_y+1];
    auxval= [ aux_x_1.*aux_y_1; aux_x_1.*aux_y_2;aux_x_2.*aux_y_1;...
    aux_x_2.*aux_y_2];
    disp('mex function')
    tic
    %interpolation_matrix = interpolation_matrix_mex(lim1,lim2,n1,n2,M);
    toc
    disp('matlab function')
    tic
    interpolation_matrix_test = sparse(lim1*lim2,n1*n2);
    %for ind_y=1:lim1%(lim1-1)
    %    for ind_x = 1:lim2%(lim2-1)
    for ind_y=1:(lim1)
        for ind_x = 1:(lim2)
            coord_x = M(ind_y,ind_x,1);
            coord_y = M(ind_y,ind_x,2);

            floor_x = floor(coord_x);
            floor_y = floor(coord_y);

            aux_x_1 = floor_x+1 - coord_x;
            aux_x_2 = 1-aux_x_1;
            aux_y_1 = floor_y+1 - coord_y;
            aux_y_2 = 1-aux_y_1;

            if floor_x > 0 && floor_y > 0 && (floor_x +1)<=n2 && (floor_y +1)<=n1  
                %if ( floor_x==99 || floor_x==100) && ( floor_y==99 || floor_y==100)
                %    disp('wait')
                %end
                interpolation_matrix_test((ind_y-1)*lim2+ind_x,(floor_x-1)*n1+floor_y) = aux_x_1*aux_y_1;
                interpolation_matrix_test((ind_y-1)*lim2+ind_x,(floor_x-1)*n1+floor_y+1) =  aux_x_1*aux_y_2;
                interpolation_matrix_test((ind_y-1)*lim2+ind_x,floor_x*n1+floor_y) =  aux_x_2*aux_y_1;
                interpolation_matrix_test((ind_y-1)*lim2+ind_x,floor_x*n1+floor_y+1) =  aux_x_2*aux_y_2;
                %interpolation_matrix((ind_y-1)*lim2+ind_x,(floor_y-1)*n1+floor_x) = aux_x_1*aux_y_1;
                %interpolation_matrix((ind_y-1)*lim2+ind_x,(floor_y-1)*n1+floor_x+1) =  aux_x_2*aux_y_1;
                %interpolation_matrix((ind_y-1)*lim2+ind_x,floor_y*n1+floor_x) =  aux_x_1*aux_y_2;
                %interpolation_matrix((ind_y-1)*lim2+ind_x,floor_y*n1+floor_x+1) =  aux_x_2*aux_y_2;
                %interpolation_matrix((ind_x-1)*lim1+ind_y,(floor_x-1)*n2+floor_y) = aux_x_1*aux_y_1;
                %interpolation_matrix((ind_x-1)*lim1+ind_y,(floor_x-1)*n2+floor_y+1) =  aux_x_1*aux_y_2;
                %interpolation_matrix((ind_x-1)*lim1+ind_y,floor_x*n2+floor_y) =  aux_x_2*aux_y_1;
                %interpolation_matrix((ind_x-1)*lim1+ind_y,floor_x*n2+floor_y+1) =  aux_x_2*aux_y_2;

            end
        end
    end
    toc
    disp('error')
    norm(interpolation_matrix(:)-interpolation_matrix_test(:))
end

%interpolation_matrix(sub2ind(size(interpolation_matrix), [(1:(lim1*lim2))';(1:(lim1*lim2))';...
%    (1:(lim1*lim2))';(1:(lim1*lim2))'],[(floor_x-1).*n1+floor_y;(floor_x-1).*n1+floor_y+1;...
%    floor_x.*n1+floor_y; floor_x.*n1+floor_y+1])) = [ aux_x_1.*aux_y_1; aux_x_1.*aux_y_2;aux_x_2.*aux_y_1;...
%    aux_x_2.*aux_y_2];
%interpolation_matrix(sub2ind(size(interpolation_matrix), (1:(lim1*lim2))',(floor_x-1).*n1+floor_y)) = aux_x_1.*aux_y_1;
%interpolation_matrix(sub2ind(size(interpolation_matrix), (1:(lim1*lim2))',(floor_x-1).*n1+floor_y+1)) =  aux_x_1.*aux_y_2;
%interpolation_matrix(sub2ind(size(interpolation_matrix), (1:(lim1*lim2))',floor_x.*n1+floor_y)) =  aux_x_2.*aux_y_1;
%interpolation_matrix(sub2ind(size(interpolation_matrix), (1:(lim1*lim2))',floor_x.*n1+floor_y+1)) =  aux_x_2.*aux_y_2;

function G = ConstructGrid( lo, hi )

% Constructs a regular grid from the range of subscripts defined by
% vectors LO and HI, and packs the result into a single array, G.
% G is D(1) x D(2) x ... x D(N) x N where D(k) is the length of
% lo(k):hi(k) and N is the length of LO and HI.

N = length(hi);
E = cell(1,N);
for i = 1:N;
    E{i} = lo(i):hi(i);  % The subscript range for each dimension
end
G = CombinedGrid(E{:});

%--------------------------------------------------------------------------

function G = CombinedGrid(varargin)

% If N >= 2, G = COMBINEDGRID(x1,x2,...,xN) is a memory-efficient
% equivalent to:
%
%   G = cell(N,1);
%   [G{:}] = ndgrid(x1,x2,...,xN);
%   G = cat(N + 1, G{:});
%
% (where x{i} = varargin{i} and D(i) is the number of
% elements in x{}).
%
% If N == 1, COMBINEDGRID returns x1 as a column vector. (The code
% with NDGRID replicates x1 across N columns, returning an N-by-N
% matrix -- which is inappropriate for our application.)
%
% N == 0 is not allowed.

N = length(varargin);
if N == 0
    eid = sprintf('Images:%s:combinegridCalledNoArgs',mfilename);
    error(eid,'%s',...
          'Internal Error: COMBINEDGRID called with no arguments.');
end

for i=1:N
    D(1,i) = numel(varargin{i});
end

if N == 1
    % Special handling required to avoid calling RESHAPE
    % with a single-element size vector.
    G = varargin{1}(:);
else
    % Pre-allocate the output array.
    G = zeros([D N]);
    
    % Prepare to generate a comma-separated list of N colons.
    colons = repmat({':'},[1 N]);
    
    for i=1:N
        % Extract the i-th vector, reshape it to run along the
        % i-th dimension (adding singleton dimensions as needed),
        % replicate it across all the other dimensions, and
        % copy it to G(:,:,...,:,i) -- with N colons.
        x = varargin{i}(:);
        x = reshape( x, [ones(1,i-1) D(i) ones(1,N-i)] );
        x = repmat(  x, [ D(1:i-1)    1     D(i+1:N) ] );
        G(colons{:},i) = x;
    end
end
